#!/bin/sh
# When changing the version number, remember to change it in the postflight script which gets copied to the resultant .pkg file
echo "ClamXAV $0 v3.5.4\n"

if [ ! -e ./buildStandaloneInstaller.sh ]
then
	echo "\nError: Sorry, this script needs to be run from within the RemoteDeploymentTool directory.\n"
	exit 1
fi

if [ ! -e ./RemoteHD/Applications/ClamXAV.app ]
then
	if [ -e /Applications/ClamXAV.app ]
	then
		echo "Copying ClamXAV.app from your Applications folder..."
		cp -Rp /Applications/ClamXAV.app ./RemoteHD/Applications/
	else
		echo "Downloading the latest version of ClamXAV..."
		rm -f ClamXAV*zip
		curl --location --progress-bar -O 'https://www.clamxav.com/downloads/ClamXAV_Latest.zip'
		ditto -xk ClamXAV*zip ./
		if [ -e ClamXAV.app ]
		then
			rm -rf ./RemoteHD/Applications/ClamXAV.app
			echo "Moving the downloaded ClamXAV.app into the RemoteHD folder..."
			mv ClamXAV.app ./RemoteHD/Applications/
		else
			echo "Error downloading/extracting the lastest version of ClamXAV."
			exit 1
		fi
	fi
fi

if [ ! -e ./RemoteHD/Applications/ClamXAV.app ]
then
	echo "\nError: ClamXAV.app is missing from the RemoteHD/Applications/ folder.\nPlease copy the latest version of ClamXAV into RemoteHD/Applications/ClamXAV.app.\n"
	exit 1
fi

if [ ! -e "./RemoteHD/Library/Application Support/ClamXAV/Settings/Licence/Licence.ClamXAV" ]
then
	if [ `/usr/bin/whoami` == "root" ]
	then
		echo "Copying ClamXAV licence file into place..."
		mkdir -p ./RemoteHD/Library/Application\ Support/ClamXAV/Settings/Licence
		cp -Rp "/Library/Application Support/ClamXAV/Settings/Licence/Licence.ClamXAV" "./RemoteHD/Library/Application Support/ClamXAV/Settings/Licence/Licence.ClamXAV"
		/bin/chmod a+r "./RemoteHD/Library/Application Support/ClamXAV/Settings/Licence/Licence.ClamXAV"
	else
		echo "\nError: ClamXAV licence file is missing from the RemoteHD folder.\nPlease re-run this script using 'sudo' and I'll be able to copy it in for you.\n"
		exit 1
	fi
fi

rm ./RemoteHD/usr/local/ClamXAV3/share/clamav/*
mkdir -p ./RemoteHD/usr/local/ClamXAV3/share/clamav
cp /usr/local/ClamXAV3/share/clamav/* ./RemoteHD/usr/local/ClamXAV3/share/clamav/
mkdir -p ./RemoteHD/Library/PrivilegedHelperTools
cp ./RemoteHD/Applications/ClamXAV.app/Contents/Library/LaunchServices/uk.co.canimaansoftware.ClamXAV.HelperTool ./RemoteHD/Library/PrivilegedHelperTools/uk.co.canimaansoftware.ClamXAV.HelperTool
cp ./RemoteHD/Applications/ClamXAV.app/Contents/Library/LaunchServices/uk.co.canimaansoftware.ClamXAV.HelperToolUpdater ./RemoteHD/Library/PrivilegedHelperTools/uk.co.canimaansoftware.ClamXAV.HelperToolUpdater
pkgbuild --root ./RemoteHD --install-location / --identifier uk.co.canimaansoftware.clamxav-installer --scripts ./scripts --component-plist components.plist ClamXAV.pkg
